import { makeStyles } from '@material-ui/core/styles';
import { BROWNISH_GREY, GREYISH_BROWN } from 'constants/colors';

const useStyles = makeStyles(() => ({
    updatingFirmwareContainer: {
        marginTop: 42,
        textAlign: 'center',
        '@media (min-width: 961px)': {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            width: '100%',
            flex: '1 0 auto',
            marginTop: 0
        }
    },
    updatingFirmwareProgressContainer: {
        display: 'flex',
        width: '100%',
        flex: '1 0 auto',
        marginTop: 0,
        maxHeight: 148,
        justifyContent: 'center'
    },
    updatingFirmwareProgress: {
        width: 148,
        height: 148
    },
    updatingFirmwareProgressBar: {
        stroke: '#68bcd8 !important',
        transition: 'stroke-dashoffset 0.5s ease 0s'
    },
    updatingFirmwareProgressBarTrail: {
        stroke: '#e7e7e7 !important'
    },
    updatingFirmwareProgressBarIcon: {
        marginTop: '-20px !important'
    },
    updatingFirmwareTitle: {
        fontSize: 22,
        fontFamily: 'Roboto-Condensed',
        fontWeight: 'bold',
        fontStyle: 'normal',
        lineHeight: 1.27,
        letterSpacing: 0.68,
        textAlign: 'center',
        color: GREYISH_BROWN,
        marginTop: 38
    },
    updatingFirmwareSubTitle: {
        color: BROWNISH_GREY,
        fontFamily: 'Lato',
        fontSize: 16,
        fontWeight: 'normal',
        fontStyle: 'normal',
        lineHeight: 1.5,
        letterSpacing: 'normal',
        marginLeft: 12
    },
    updatingFirmwareSubContainer: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'center',
        marginTop: 16
    }
}));

export default useStyles;
